<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$shotcode_id = 'pricing_item';
$group_image = 'Image';
$group_color = 'Color';

// Shortcode settings
return array(
	'name'    => esc_html__( 'Pricing Item', 'penci-framework' ),
	'weight'  => 700,
	'params'  => array_merge(
		array(
			array(
				'type'       => 'dropdown',
				'heading'    => esc_html__( 'Design style', 'penci-framework' ),
				'param_name' => '_design_style',
				'std'        => 's1',
				'value'      => array(
					esc_html__( 'Style 1', 'penci-framework' ) => 's1',
					esc_html__( 'Style 2', 'penci-framework' ) => 's2',
				),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => __( 'Use image', 'penci-framework' ),
				'param_name' => '_use_img',
			),
			array(
				'type'       => 'attach_image',
				'heading'    => esc_html__( 'Image', 'penci-framework' ),
				'param_name' => '_image',
				'dependency' => array( 'element' => '_use_img', 'value' => 'true', ),
				'group'      => $group_image,
			),
			array(
				'type'       => 'penci_number',
				'param_name' => 'image_width',
				'heading'    => __( 'Image width', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'dependency' => array( 'element' => '_use_img', 'value' => 'true', ),
				'group'      => $group_image,
			),
			array(
				'type'       => 'penci_number',
				'param_name' => 'image_height',
				'heading'    => __( 'Image height', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'dependency' => array( 'element' => '_use_img', 'value' => 'true', ),
				'group'      => $group_image,
			),
			array(
				'type'       => 'penci_number',
				'param_name' => 'image_mar_top',
				'heading'    => __( 'Image margin top', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'dependency' => array( 'element' => '_use_img', 'value' => 'true', ),
				'group'      => $group_image,
			),
			array(
				'type'       => 'penci_number',
				'param_name' => 'image_mar_bottom',
				'heading'    => __( 'Image margin bottom', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'dependency' => array( 'element' => '_use_img', 'value' => 'true', ),
				'group'      => $group_image,
			),
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Pricing Name / Title', 'penci-framework' ),
				'param_name'  => '_heading',
				'description' => __( 'Enter the pricing name', 'penci-framework' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Pricing  Subtitle', 'penci-framework' ),
				'param_name'  => '_subheading',
				'description' => __( 'Enter short description', 'penci-framework' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Price', 'penci-framework' ),
				'param_name'  => '_price',
				'description' => __( 'Enter the price', 'penci-framework' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Price Unit', 'penci-framework' ),
				'param_name'  => '_unit',
				'description' => __( 'Enter the price unit for this package. e.g. per month', 'penci-framework' ),
			),
			array(
				'type'        => 'textarea_html',
				'class'       => '',
				'heading'     => __( 'Features', 'ultimate_vc' ),
				'param_name'  => 'content',
				'value'       => '',
				'description' => __( 'Create the features list using un-ordered list elements.', 'penci-framework' ),
			),
			array(
				'type'        => 'textfield',
				'heading'     => __( 'Button Text', 'penci-framework' ),
				'param_name'  => '_btn_text',
				'description' => __( 'Enter call to action button text', 'penci-framework' ),
			),
			array(
				'type'        => 'vc_link',
				'class'       => '',
				'heading'     => __( 'Button Link', 'smile' ),
				'param_name'  => '_btn_link',
				'value'       => '',
				'description' => __( 'Select / enter the link for call to action button', 'ultimate_vc' ),
			),
			array(
				'type'       => 'checkbox',
				'heading'    => esc_html__( 'Make this pricing box as featured', 'penci-framework' ),
				'param_name' => '_featured',
				'value'      => array( __( 'Yes', 'penci-framework' ) => 'yes' ),
			),
			array(
				'type'       => 'penci_only_number',
				'param_name' => 'min_height',
				'heading'    => __( 'Minimum height for pricing item', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'max'        => 1000,
			),
			array(
				'type'       => 'penci_number',
				'param_name' => '_heading_mar_bottom',
				'heading'    => __( 'Pricing title margin bottom', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'       => 'penci_number',
				'param_name' => '_subheading_mar_b',
				'heading'    => __( 'Pricing subtitle margin bottom', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'       => 'penci_number',
				'param_name' => '_price_mar_bottom',
				'heading'    => __( 'Pricing margin bottom', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'       => 'penci_number',
				'param_name' => '_unit_mar_bottom',
				'heading'    => __( 'Price unit margin bottom', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'       => 'penci_number',
				'param_name' => '_features_martop',
				'heading'    => __( 'Features margin top', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'       => 'penci_number',
				'param_name' => '_features_bottom',
				'heading'    => __( 'Features margin bottom', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'       => 'penci_number',
				'param_name' => 'item_fea_bottom',
				'heading'    => __( 'Item of list features margin bottom', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'       => 'penci_number',
				'param_name' => 'btn_mar_top',
				'heading'    => __( 'Button margin top', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'       => 'penci_number',
				'param_name' => 'btn_width',
				'heading'    => __( 'Button width', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),array(
				'type'       => 'penci_number',
				'param_name' => 'btn_height',
				'heading'    => __( 'Button Height', 'penci-framework' ),
				'value'      => '',
				'std'        => '',
				'suffix'     => 'px',
				'min'        => 1,
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Color
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Background color for pricing item', 'penci-framework' ),
				'param_name'       => 'bg_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Border color for pricing item', 'penci-framework' ),
				'param_name'       => 'border_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Pricing Title color', 'penci-framework' ),
				'param_name'       => '_heading_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Pricing subtitle', 'penci-framework' ),
				'param_name'       => '_subheading_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Price color', 'penci-framework' ),
				'param_name'       => '_price_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Price unit color', 'penci-framework' ),
				'param_name'       => '_unit_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Features color', 'penci-framework' ),
				'param_name'       => 'features_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button background color', 'penci-framework' ),
				'param_name'       => 'btn_bgcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button border color', 'penci-framework' ),
				'param_name'       => 'btn_borcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button text color', 'penci-framework' ),
				'param_name'       => 'btn_text_color',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button background hover color', 'penci-framework' ),
				'param_name'       => 'btn_hbgcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button border hover color', 'penci-framework' ),
				'param_name'       => 'btn_hborcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
			array(
				'type'             => 'colorpicker',
				'heading'          => esc_html__( 'Button text hover color', 'penci-framework' ),
				'param_name'       => 'btn_text_hcolor',
				'group'            => $group_color,
				'edit_field_class' => 'vc_col-sm-6',
			),
		),
		Penci_Framework_Shortcode_Params::block_option_typo(
			array(
				'prefix'       => 'title',
				'title'        => esc_html__( 'Pricing Name / Title settings' ),
				'google_fonts' => Penci_Helper_Shortcode::get_font_family( 'roboto' ),
				'font-size'    => '36px',
			)
		),
		Penci_Framework_Shortcode_Params::block_option_typo(
			array(
				'prefix'       => 'subtitle',
				'title'        => esc_html__( 'Pricing Subtitle settings' ),
				'google_fonts' => Penci_Helper_Shortcode::get_font_family( 'roboto' ),
				'font-size'    => '14px',
			)
		),
		Penci_Framework_Shortcode_Params::block_option_typo(
			array(
				'prefix'       => 'price',
				'title'        => esc_html__( 'Price settings' ),
				'google_fonts' => Penci_Helper_Shortcode::get_font_family( 'roboto' ),
				'font-size'    => '48px',
			)
		),
		Penci_Framework_Shortcode_Params::block_option_typo(
			array(
				'prefix'       => '_unit',
				'title'        => esc_html__( 'Price Unit settings' ),
				'google_fonts' => Penci_Helper_Shortcode::get_font_family( 'roboto' ),
				'font-size'    => '14px',
			)
		),
		Penci_Framework_Shortcode_Params::block_option_typo(
			array(
				'prefix'       => 'features',
				'title'        => esc_html__( 'Features settings' ),
				'google_fonts' => Penci_Helper_Shortcode::get_font_family( 'roboto' ),
				'font-size'    => '14px'
			)
		),
		Penci_Framework_Shortcode_Params::block_option_typo(
			array(
				'prefix'       => 'btn',
				'title'        => esc_html__( 'Button settings' ),
				'google_fonts' => Penci_Helper_Shortcode::get_font_family( 'roboto' ),
				'font-size'    => '14px',
			)
		)
	),
	'js_view' => 'VcPenciShortcodeView',
);